//******************************************
//           This is a C Template file
//ߣ   
//     
//
//ע
//****************************************** 
/*							Pin Assignment
*********************************************************************
.........................-----------------............................
01.VSS.................01|O              |20.VDD
02.P00/XIN.............02|               |19.P40/AIN0/KWI0
03.P01/XOUT............03|     QFN-20    |18.P41/AIN1/KWI1
04.P10/RESETB..........04|               |17.P42/AIN2/KWI2
05.P71/TC01/PWM01B.....05|               |16.P43/AIN3/KWI3/VREF
06.P90/TX/RX...........06|     LQFP-20   |15.P44/AIN4/KWI4       
07.P91/RX/TX...........07|               |14.P74/DVOB/AIN8/SI/KWI13
08.P72/TCA0/PPGA0B.....08|	             |13.P76/INT3/SCLK/KWI15
09.P82/TC04/PWM04B.....09|               |12.P70/TC00/PWM00B
10.P83/TC05/PWM05B.....10|	             |11.P75/INT2/SO/KWI14
.........................-----------------............................
*********************************************************************/
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"
#include "iApp.h"

//-- header guards --//


//-- ȫֱ --//


void PWM01_COMP_SEL_init(uint T1, uint T2, uint T3, uint T4);
void PWM01_COMP_adj(uint T1, uint T2, uint T3, uint T4);


//-- ȫֳ --//



void main()
{
//----------------------------------------------------------------------//
//****** IO, CGCR and P10/P40/P41 initialization during debugging ****************//
//----------------------------------------------------------------------//
	SYSTEM_INIT();		// IO, CGCR and P10/P40/P41 initialization during debugging
//----------------------------------------------------------------------//
	WDCDR.byte = 0x4e;				// clear wdt

//--------------------------------------------------------------------------------------------------//
//	Please set the external crystal (HXTAL/LXTAL) from <OPmode.h> and refer to the following instructions:
//.....................................................................................
//#undef	XTAL_High		// define an external high-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//#undef	XTAL_Low		// define an external low-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//.....................................................................................
//	please change the above program in the <OPmode.h> file
//	please pay attention to the external crystal switching in this document
//--------------------------------------------------------------------------------------------------//




	P8DR.byte = 0x00;
	P8CR.byte = 0xff;
	P9DR.byte = 0x00;
	P9CR.byte = 0xff;


	P7DR.byte = 0x00;
	P7CR.byte = 0x03;
__asm("CPL (_P7DR).0");
__asm("CPL (_P7DR).0");
__asm("CPL (_P7DR).1");
__asm("CPL (_P7DR).1");



	WDCDR.byte = 0x4e;				// clear wdt
__asm("CPL (_P8DR).2");
__asm("CPL (_P8DR).2");
__asm("CPL (_P8DR).3");
__asm("CPL (_P8DR).3");
__asm("CPL (_P9DR).0");
__asm("CPL (_P9DR).0");
__asm("CPL (_P9DR).1");
__asm("CPL (_P9DR).1");



	PWM01_COMP_SEL_init( 300,  500,  800, 1001);		// t1<t2<t3<t4 : (1~1023)
	delay_times(t_1ms, 100);


	PWM01_COMP_adj(      200,  600,  900, 1023);		// t1<t2<t3<t4 : (1~1023)
	delay_times(t_1ms, 100);

//for( iloop=10; iloop<24; iloop++ )
//{
//	PWM01_COMP_adj( 200,  600,  800, 1000+iloop);
//	look_data(iloop);
//	delay_times(t_1ms, 100);
//}
//---------------------------------------
//---------------------------------------
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt
		__asm("CPL (_P9DR).0");
		__asm("CPL (_P9DR).0");
		__asm("CPL (_P9DR).0");
		__asm("CPL (_P9DR).0");
	}

}



//*********************************************************************
// name			: PWM01_COMP_SEL_init()
// brief		: PWM0xB: 10λģʽ
// note			:
//************************************
//	10λʾͼ
//************************************
//             _ _ _ _ _ _                         _ _ _ _ _ _
//            |           |                       |           |
//PWM00B   _ _|           |_ _ _ _ _ _ _ _ _ _ _ _|           |_ _ _ _ _ _ _ _ _ _ _ _
//                             _ _ _ _ _ _ _                       _ _ _ _ _ _ _
//                            |             |                     |             |
//PWM01B   _ _ _ _ _ _ _ _ _ _|             |_ _ _ _ _ _ _ _ _ _ _|             |_ _ _
//
//            ^           ^   ^             ^    ^
//            ^           ^   ^             ^    ^
//            ^           ^   ^             ^    ^
//            ^           ^   ^             ^    ^
//----------------------------------------------------------------------------------------
//            S           T   T             T    T
//            t           1   2             3    4
//            a                                  |
//            r<<----------- Cycle ------------>>|
//            t                                  |
//*********************************************************************
void PWM01_COMP_SEL_init(uint T1, uint T2, uint T3, uint T4)
{
	__asm("DI");
	POFFCR0.byte  = 0x10;
	// interrupt request setting
	ILH.bit.b4    = 0;
	ILH.bit.b5    = 0;
	EIRH.bit.b4   = 1;
	EIRH.bit.b5   = 1;
	// interrupt request setting
	__asm("EI");

	T00MOD.byte   = 0xEA;			// TFF0 = 1
	T01MOD.byte   = 0x7A;			// TFF1 = 0
	P7FC.byte     = 0x03;			// setting PxFC after TFFx

	T00REGL.byte  = (T4%0x0100);	// T4: totoal cycle
	T00REGH.byte  = (T4/0x0100);	// T4: totoal cycle
	T00PWML.byte  = (T1%0x0100);	// T1: 1st falling edge
	T00PWMH.byte  = (T1/0x0100);	// T1: 1st falling edge

	T01REGL.byte  = (T3%0x0100);	// T3: 3rd falling edge
	T01REGH.byte  = (T3/0x0100);	// T3: 3rd falling edge
	T01PWML.byte  = (T2%0x0100);	// T2: 2nd rising edge
	T01PWMH.byte  = (T2/0x0100);	// T2: 2nd rising edge

	T001CR.byte   = 0x13;			// start PPG00B/PPG01B
}


//*********************************************************************
// name			: PWM01_COMP_adj()
// brief		: PWM0xB: 10λ޸
// note			:
//*********************************************************************
void PWM01_COMP_adj(uint T1, uint T2, uint T3, uint T4)
{
	T00REGL.byte  = (T4%0x0100);	// T4: totoal cycle
	T00REGH.byte  = (T4/0x0100);	// T4: totoal cycle
	T00PWML.byte  = (T1%0x0100);	// T1: 1st falling edge
	T00PWMH.byte  = (T1/0x0100);	// T1: 1st falling edge

	T01REGL.byte  = (T3%0x0100);	// T3: 3rd falling edge
	T01REGH.byte  = (T3/0x0100);	// T3: 3rd falling edge
	T01PWML.byte  = (T2%0x0100);	// T2: 2nd rising edge
	T01PWMH.byte  = (T2/0x0100);	// T2: 2nd rising edge
}

